unit MomentScope01;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs, ExtCtrls, StdCtrls,
  UserApp03Data, Service01;

type TMomentScope = class(TObject)
private
  // ------------------------
  fImg         : TImage;    //  Image
  // ------------------------
  fScRect      : TRect;     //   
  fXYZero      : TPoint;    //   
  fAZnRect     : TRect;     // Rect   X  Y
  fPnMRoll     : TPoint;    //      
  fPnMPitch    : TPoint;    //      
  fPnMTurn     : TPoint;    //      

  // ------------------------
  fBmp         : TBitMap;   //    
  fVisible     : boolean;   //  
  // -----------------------
  fMaxMoment   : extended;  //    
  fMomentDim   : string;    //  
  // -----------------------
  fMScale      : extended;  //      
  fMRoll       : extended;  //   
  fMPitch      : extended;  //   
  fMTurn       : extended;  //   
  // -----------------------
  //   
  procedure SetVisible(RqVisible : boolean);
  //        
  procedure SetMScale(RqMaxMoment : extended);
  //      
  procedure SetMaxMoment(RqMaxMoment : extended);
  //     
  procedure SetMRoll(RqMRoll : extended);
  //     
  procedure SetMPitch(RqMPitch : extended);
  //     
  procedure SetTurn(RqMTurn : extended);

  //       
  function CalcScopePix(RqValue : extended) : integer;
  //   
  procedure ShowAirCraft(RqX, RqY : integer);
  //    
  procedure ShowGraphScope (RqPoint   : TPoint;
                            RqOriente : char;
                            RqValue   : extended);
  //     
  procedure ShowScopeValue(RqTop   : integer;
                           RqValue : extended;
                           RqTitle : string);
  //  
  procedure ShowAll();
public
  // ------------------------
  //  / 
  constructor  Create(RqImage : TImage; XBSc, YBSc : integer);
  procedure Free();

  // ------------------------
  property Visible : boolean read fVisible write SetVisible;
  //    
  property  MaxMoment  : extended read fMaxMoment write SetMaxMoment;
  //    
  property  MomentDim  : string   read fMomentDim write fMomentDim;
  //   
  property  MRoll      : extended read fMRoll  write SetMRoll;
  //   
  property  MPitch     : extended read fMPitch write SetMPitch;
  //   
  property  MTurn      : extended read fMTurn  write SetTurn;

end;

implementation

// ================================================================
//      
// ================================================================
// ----------------------------------------------------------------
//  
const AC01 : array[0..13] of TPoint =
( //   
 (X : 000; Y : 034),
 (X : 008; Y : 027),
 (X : 016; Y : 025),
 //  
 (X : 130; Y : 025),
 (X : 145; Y : 004),
 (X : 150; Y : 004),
 (X : 146; Y : 025),
 //   
 (X : 150; Y : 025),
 (X : 148; Y : 028),
 //   
 (X : 120; Y : 036),
 (X : 100; Y : 038),
 (X : 075; Y : 040),
 (X : 015; Y : 040),
 (X : 000; Y : 036)
);
const AC02 : array[0..4] of TPoint =
( //  
 (X : 054; Y : 030),
 (X : 022; Y : 070),
 (X : 032; Y : 070),
 (X : 084; Y : 030),
 (X : 054; Y : 030)
);
const AC03 : array[0..4] of TPoint =
( //  
 (X : 060; Y : 025),
 (X : 092; Y : 000),
 (X : 100; Y : 000),
 (X : 086; Y : 025),
 (X : 060; Y : 025)
);
// ----------------------------------------------------------------
//    
const // ------------
      XLenSc = 260;    // X -   Rect 
      YLenSc = 200;    // Y -   Rect 
      // ------------
      XLenCr = 150;    // X -   
      YLenCr = 70;     // Y -   
      // ------------
      XBAx    = 80;    // X -  Rect    Rect
      YBAx    = 18;    // Y -  Rect    Rect
      HLenAx  = 50;    //     Rect 
      // ------------
      XOffCr = -66;    // X -     
      YOffCr = -30;    // Y -     

// ----------------------------------------------------------------
const ScopeLen       = HLenAx;  //    
      ScopeMaxMScale = 1;       //  
      // ------------
      ScopeTxtXB     = 140;     // X -    fScRect
      ScopeTxtYB     = 86;      // Y -    fScRect


// ================================================================
//    / 
// ================================================================
// ----------------------------------------------------------------
constructor TMomentScope.Create(RqImage : TImage; XBSc, YBSc : integer);
begin
   inherited Create;
   // ---------------
   //  fImg
   fImg   := RqImage;
   if not Assigned(fImg.Picture)
   then begin
      fImg.Picture := TPicture.Create;
      with fImg.Picture.Bitmap
      do begin
         if Width  <> fImg.Width   then Width  := fImg.Width;
         if Height <> fImg.Height  then Height := fImg.Height;
         if PixelFormat <> pf24bit then PixelFormat := pf24bit;
      end;
   end;
   // ---------------
   //    Rect    Image
   fScRect := Rect(Point(XBSc,YBSc),Point(XBSc + XLenSc,YBSc + YLenSc));
   //      
   fAZnRect := Rect(XBSc + XBAx, YBSc + YBAx,
                    XBSc + XBAx + 2 * HLenAx,
                    YBSc + YBAx + 2 * HLenAx);
   // ---------------
   //    
   fXYZero.X := fAZnRect.Left + HLenAx;
   fXYZero.Y := fAZnRect.Top  + HLenAx;
   // ---------------
   //       :
   //   
   fPnMRoll.X := fAZnRect.Left   - 20;
   fPnMRoll.Y := fAZnRect.Bottom + 20;
   //   
   fPnMPitch.X := fAZnRect.Left  - 40;
   fPnMPitch.Y := fXYZero.Y;
   //   
   fPnMTurn := fPnMRoll;
   // ---------------
   SetMaxMoment(1000);
   fMomentDim  := ' * ';
   // ---------------
   fBmp     := TBitMap.Create;
   // ---------------
   fVisible := False;
   self.SetVisible(True);
end;

// -----------------------------------------------------------------
procedure TMomentScope.Free();
begin
   if Assigned(fBmp)
   then begin
       if fVisible then SetVisible(False);
       fBmp.Free();
   end;
   inherited Free();
end;
// ================================================================
//    
// ================================================================
// ----------------------------------------------------------------
//        
procedure TMomentScope.SetMScale(RqMaxMoment : extended);
begin
   fMScale := ScopeMaxMScale;
   if Abs(RqMaxMoment) > 1e-6
   then begin
     fMScale := Abs(ScopeLen/RqMaxMoment);
     if fMScale > ScopeMaxMScale then fMScale := ScopeMaxMScale;
   end;
end;

// ----------------------------------------------------------------
// 02.02.2017
//   
procedure TMomentScope.ShowAirCraft(RqX, RqY : integer);
var wArr : array of Tpoint;
    Ind  : integer;
begin
   with fImg.Canvas
   do begin

      // ---------------------------
      SetLength(wArr, Length(AC01));
      for Ind := Low(wArr) to High(wArr)
      do begin
         wArr[Ind].X := RqX + AC01[Ind].X;
         wArr[Ind].Y := RqY + AC01[Ind].Y;
      end;
      Brush.Color := RGB(160,210,210);
      Polygon(wArr);
      // ---------------------------
      SetLength(wArr, Length(AC02));
      for Ind := Low(wArr) to High(wArr)
      do begin
         wArr[Ind].X := RqX + AC02[Ind].X;
         wArr[Ind].Y := RqY + AC02[Ind].Y;
      end;
      Brush.Color := RGB(190,255,255);
      Polygon(wArr);
      // ---------------------------
      SetLength(wArr, Length(AC03));
      for Ind := Low(wArr) to High(wArr)
      do begin
         wArr[Ind].X := RqX + AC03[Ind].X;
         wArr[Ind].Y := RqY + AC03[Ind].Y;
      end;
      Brush.Color := RGB(190,255,255);
      Polygon(wArr);
      // ---------------------------
      //  
      Pen.Color := clBlue;
      //  X
      MoveTo(fPnMPitch.X,    fPnMPitch.Y);
      LineTo(fXYZero.X,      fXYZero.Y);
      //  Y
      MoveTo(fPnMRoll.X,     fPnMRoll.Y);
      LineTo(fXYZero.X,      fXYZero.Y);
     // LineTo(fAZnRect.Right, fAZnRect.Top);
   end;
end;
// ----------------------------------------------------------------
//       
function TMomentScope.CalcScopePix(RqValue : extended) : integer;
begin
   Result := Round(fMScale * RqValue);
   if Abs(Result) > ScopeLen
   then if Result >= 0
        then Result :=   ScopeLen
        else Result := - ScopeLen;
end;

// ----------------------------------------------------------------
//     
procedure TMomentScope.ShowScopeValue(RqTop   : integer;
                                      RqValue : extended;
                                      RqTitle : string);
var wLeft, wTop : integer;
begin
    with fImg.Canvas do
    begin
       Brush.Style := bsClear;
       wLeft := fScRect.Left + ScopeTxtXB;
       wTop  := fScRect.Top  + ScopeTxtYB + RqTop;
       //  
       if  RqValue > 0
       then Font.Color := RGB(255,0,0)
       else Font.Color := RGB(0,0,255);
       TextOut(wLeft + 45, wTop, ':  ' + Format('%6.1f',[RqValue]));
       //   
       if Abs(RqValue) <= fMaxMoment
       then Font.Color := clBlack;
       TextOut(wLeft,  wTop, RqTitle);
    end;
end;

// ----------------------------------------------------------------
//    
procedure TMomentScope.ShowGraphScope (RqPoint   : TPoint;
                                       RqOriente : char;
                                       RqValue   : extended);
var wPix : integer;
begin
    with fImg.Canvas do
    begin
       Brush.Style := bsSolid;
       if RqValue > 0
       then Brush.Color := RGB(255,0,0)
       else Brush.Color := RGB(0,0,255);
       Pen.Color  := Brush.Color;
       wPix := CalcScopePix(RqValue);
       case RqOriente of
       'V' : Rectangle(RqPoint.X - 2, RqPoint.Y,
                       RqPoint.X + 2, RqPoint.Y - wPix);
       'H' : Rectangle(RqPoint.X,        RqPoint.Y - 2,
                       RqPoint.X + wPix, RqPoint.Y + 2);
       end;
    end;
end;

// ----------------------------------------------------------------
//  
procedure TMomentScope.ShowAll();
begin
    if not fVisible then Exit;
    with fImg.Canvas do
    begin
       // ---------------------------
       //  
       Pen.Width := 1;
       Pen.Color := clBlack;
       Font.Color := clBlack;
       Brush.Style := bsSolid;
       Brush.Color := RGB(240,240,240); // clWindow;
       Rectangle(fScRect);
       // ---------------------------
       // 
       TextOut(fScRect.Left + 60, fScRect.Top + 4, ' ');
       TextOut(fScRect.Left + 60,
               fScRect.Top  + TextHeight('1') + 4, '  ');
       // ---------------------------
       //     
       ShowAirCraft(fXYZero.X + XOffCr, fXYZero.Y + YOffCr);
       // ---------------------------
       //   
       // ---------------------------
       //  
       ShowGraphScope (fPnMRoll, 'V', fMRoll);
       ShowScopeValue( 0, fMRoll, '');
       //  
       ShowGraphScope (fPnMPitch, 'V', fMPitch);
       ShowScopeValue(TextHeight('1'), fMPitch, '');
       //  
       ShowGraphScope (fPnMTurn, 'H', fMTurn);
       ShowScopeValue( 2* TextHeight('1'), fMTurn, '');
       // ---------------------------
       // 
       Font.Color := clBlack;
       TextOut(fScRect.Left   + 100,
               fScRect.Bottom - 40,
               ' ');
       TextOut(fScRect.Left   + 100,
               fScRect.Bottom - 40 + TextHeight('1'),
               '  : ' + fMomentDim);
    end;
end;

// ================================================================
//    PROPERTYEs
// ================================================================
// ----------------------------------------------------------------
//   
procedure TMomentScope.SetVisible(RqVisible : boolean);
begin
  if RqVisible
  then begin
      if (not fVisible)
      then begin
         //    
         if SaveBitMap
           (fImg.Picture.Bitmap,           // BitMap 
            fBmp,                          // BitMap 
            fScRect)                       // Rect 
         then begin
           //    fImg
           fVisible := True;
           ShowAll();
           fImg.Repaint;                  //  fImg
         end;
      end;
  end
  else begin
      if fVisible
      then begin
         //    
         if RestoreBitMap
            (fBmp,                         // BitMap 
             fImg.Picture.Bitmap,          // BitMap 
             fScRect.Left, fScRect.Top)    //  X,Y  
         then begin
            fVisible := False;
            fImg.Repaint;                  //  fImg
         end;
      end;
  end;
end;

// ----------------------------------------------------------------
//      
procedure TMomentScope.SetMaxMoment(RqMaxMoment : extended);
begin
   fMaxMoment := Abs(RqMaxMoment);
   SetMScale(fMaxMoment);
end;

// ----------------------------------------------------------------
//     
procedure TMomentScope.SetMRoll(RqMRoll : extended);
begin
   fMRoll := RqMRoll;
   if fVisible then ShowAll();
end;

//     
procedure TMomentScope.SetMPitch(RqMPitch : extended);
begin
   fMPitch := RqMPitch;
   if fVisible then ShowAll();
end;

//     
procedure TMomentScope.SetTurn(RqMTurn : extended);
begin
   fMTurn := RqMTurn;
   if fVisible then ShowAll();
end;


// ----------------------------------------------------------------
// ----------------------------------------------------------------
// ----------------------------------------------------------------
// ----------------------------------------------------------------
// ================================================================
//   
// ================================================================

end.
